attribute vec2 coord;

uniform vec3 translate;
uniform vec2 scale;

uniform vec3 cam_right;
uniform vec3 cam_up;
uniform mat4 vp;

#ifdef TEXTURE
attribute vec2 texcoord;
varying vec2 f_texcoord;
#endif

#ifdef HIGHLIGHT
attribute float highlight_factor;
varying float f_highlight_factor;
#endif

void main(void)
{
	vec3 posBillboard = translate + cam_right*coord.x*scale.x + cam_up*coord.y*scale.y;
	vec4 positionWorld = vec4(posBillboard, 1.0);
	gl_Position = vp * positionWorld;

#ifdef TEXTURE
	f_texcoord = texcoord;
#endif

#ifdef HIGHLIGHT
	f_highlight_factor = highlight_factor;
#endif
}
